/*
 * Decompiled with CFR 0.152.
 */
package com.android.files.data;

import com.android.files.domain.model.FileData;
import com.android.files.domain.util.AndroidFilesHandler;
import com.android.files.domain.util.BinaryDataService;
import com.android.files.domain.util.FileIdData;
import com.utility.GetIdentity;
import com.utility.TncJdbc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.web.multipart.MultipartFile;

public class BlobDataService
implements BinaryDataService {
    private final TncJdbc jdbc;

    public BlobDataService(TncJdbc jdbc) {
        this.jdbc = jdbc;
    }

    public long store(MultipartFile file, AndroidFilesHandler.PictureType type) throws IOException {
        FileIdData idData = this.getSrcIdCode(file.getOriginalFilename());
        String sql = "INSERT INTO HloPictures([CODE], [PICTURE], [TYPE], IMAGE_SRC) VALUES (?, ?, ?, ?)";
        this.jdbc.update(sql, ps -> {
            ps.setString(1, idData.getEntityCode());
            try {
                ps.setBinaryStream(2, file.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ps.setInt(3, type.getType());
            ps.setString(4, idData.getFileSrc());
        });
        long id = GetIdentity.invoke((TncJdbc)this.jdbc);
        this.updatePath(file, type, this.jdbc);
        return id;
    }

    public Resource loadAsResource(String fileId) {
        FileIdData idData = this.getSrcIdCode(fileId);
        SqlRowSet rs = this.jdbc.queryForRowSet(" SELECT [PICTURE] FROM HLOPictures \n WHERE image_src = ? AND [ID] = ? AND [CODE] = ?", new Object[]{idData.getFileSrc(), idData.getId(), idData.getEntityCode()});
        if (!rs.next()) {
            return null;
        }
        Object result = rs.getObject("PICTURE");
        if (result == null) {
            return null;
        }
        return new ByteArrayResource((byte[])result);
    }

    public List<String> loadAllAsBase64(String entityId) {
        SqlRowSet rs = this.jdbc.queryForRowSet(" SELECT [PICTURE] FROM HLOPictures \n WHERE [CODE] = ? ", new Object[]{entityId});
        ArrayList<String> result = new ArrayList<String>();
        Base64.Encoder encoder = Base64.getEncoder();
        while (rs.next()) {
            Object picture = rs.getObject("PICTURE");
            if (picture == null) continue;
            String base64 = encoder.encodeToString((byte[])picture);
            result.add(base64);
        }
        return result;
    }

    public long getSize(FileData fileData) {
        if (fileData.getFileData() == null) {
            return Math.max(fileData.getFileSize(), 0L);
        }
        return fileData.getFileData().length;
    }
}

